/***************************************************************************
 *
 * Copyright (c) 2013 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef SLIDER_SUBDIVISION_H_INCLUDED
#define SLIDER_SUBDIVISION_H_INCLUDED

#include <sys/types.h>

#include <fstream>
#include <string>

#include "CalibrationTypes.h"
#include "Subdivision.h"

using namespace std;

namespace LayerManagerCalibration
{
    class SliderSubdivision : public Subdivision
    {
    public:
        enum Orientation {
            HORIZONTAL,
            VERTICAL
        };
        SliderSubdivision();

        float getMinimumValue();
        float getMaximumValue();
        Orientation getOrientation();
        bool validate();

    protected:
        virtual ~SliderSubdivision();
        bool handleUnknownKey(const string& key, const string& value);

    private:
        float m_fpMinimumValue;
        float m_fpMaximumValue;
        Orientation m_eOrientation;

        bool m_bMinimumValueParsed;
        bool m_bMaximumValueParsed;
        bool m_bOrientationParsed;
    };

    inline SliderSubdivision::SliderSubdivision()
        : Subdivision(SLIDER),
          m_bMinimumValueParsed(false),
          m_bMaximumValueParsed(false),
          m_bOrientationParsed(false)
    {
    }

    inline SliderSubdivision::~SliderSubdivision()
    {
    }

    inline float SliderSubdivision::getMinimumValue()
    {
        return m_fpMinimumValue;
    }

    inline float SliderSubdivision::getMaximumValue()
    {
        return m_fpMaximumValue;
    }

    inline SliderSubdivision::Orientation SliderSubdivision::getOrientation()
    {
        return m_eOrientation;
    }
}

#endif
